#include<iostream>
#include<cassert>

using namespace std;

const int MAXN = 100*1000 + 10;

struct barbell{
    int M, L, W, N, K;
    pair<long long, long long> fingerboard; 
    pair<long long, long long> A_pref[MAXN], B_pref[MAXN];

    void read(istream & in = cin){
        in >> M >> L >> W >> N >> K;
        fingerboard = make_pair(M * 1LL * L , M * 1LL * L);
        
        int tmp;
        for(int i = 0; i < N; i++){
            in >> tmp;
            A_pref[i + 1] = make_pair(-tmp * (      (i*2 + 1) * 1LL * W), 
                                    tmp * (2*L + (i*2 + 1) * 1LL * W));
            A_pref[i + 1].first += A_pref[i].first;
            A_pref[i + 1].second += A_pref[i].second;
        }
            
        for(int i = 0; i < K; i++){
            in >> tmp;
            B_pref[i + 1] = make_pair( tmp * (2*L + (i*2 + 1) * 1LL * W), 
                                    -tmp * (      (i*2 + 1) * 1LL * W));
            B_pref[i + 1].first += B_pref[i].first;
            B_pref[i + 1].second += B_pref[i].second;
        }

        assert(good_setup(A_pref[N], B_pref[K], fingerboard) && 
            "Barbell is not balanced!");
    }

    bool good_setup(const pair<long long, long long> & A,
                    const pair<long long, long long> & B,
                    const pair<long long, long long> & center){
                        return A.first + B.first + center.first >= 0 &&
                            A.second + B.second + center.second >= 0;
    }

    pair<int, int> solve(){
        int l = N, r = K;
        bool current_side = 0; //starting from left

        bool something_was_changed = 1;
        int moves = 0;
        while(something_was_changed){
            something_was_changed = 0;
            if(current_side == 0)
                while(l > 0 && good_setup(A_pref[l - 1], B_pref[r], fingerboard) )
                    l--,
                    something_was_changed = 1;
            else 
                while(r > 0 && good_setup(A_pref[l], B_pref[r - 1], fingerboard) )
                    r--,
                    something_was_changed = 1;

            
            current_side ^= 1;
            if(something_was_changed)
                moves++;
            else 
                if(moves > 0)
                    moves--;
        }

        pair<int, int> best = make_pair(N + K - l - r, moves);
        moves = 0;
        something_was_changed = 1;
        l = N, r = K;
        current_side = 1;

        while(something_was_changed){
            something_was_changed = 0;
            if(current_side == 0)
                while(l > 0 && good_setup(A_pref[l - 1], B_pref[r], fingerboard) )
                    l--,
                    something_was_changed = 1;
            else 
                while(r > 0 && good_setup(A_pref[l], B_pref[r - 1], fingerboard) )
                    r--,
                    something_was_changed = 1;

            current_side ^= 1;
            if(something_was_changed)
                moves++;
            else 
                if(moves > 0)
                    moves--;
        }
        
        if(best.first < N + K - l - r || 
        (best.first == N + K - l - r && best.second > moves))
            best = make_pair(N + K - l - r, moves);
        return best;
    }
} BB;


int main(){
    ios::sync_with_stdio(false);
    cin.tie(0);

    BB.read();
    pair<int, int> ans = BB.solve();
    cout << ans.first << ' ' << ans.second;
    
    return 0;
}